'use strict';

function BCPReportsModalCtrl($scope, $window, ReportsList){
    var elementId = "#modal-reports";

    $scope.modal = false;

    $scope.$on('Reports:openReportsModal', function(event){
        $scope.boughtReportsList = ReportsList.loadData();

        $scope.openModal();
    });

    $scope.isAnyToBuy = function(){
        return ReportsList.isAnyToBuy();
    }

    $scope.isAnyBought = function(){
        return ReportsList.isAnyBought();
    }

    $scope.openModal = function(){
        angular.element(elementId).modal('show');
    }

    $scope.closeModal = function(){
        angular.element(elementId).modal('hide');
    }

    $scope.showReport = function(report) {
        $window.open(appDev + '/report/' + report.code);
    }
}

BCPReportsModalCtrl.$inject = ['$scope', '$window', 'ReportsList'];